unit fSched;
  // created by: JIT, pvamc
  // created on: 3-10-06


interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, ORCtrls, Vawrgrid, StdCtrls, ExtCtrls, ORDtTm,
  TRPCB, ORFn, ORNet, Mfunstr, uCore, rCore, fSurgCase, fRptBox, Buttons,
  Menus;

type
  TfrmSched = class(TForm)
    drgrSched: TDrawGrid;
    lblOR1: TLabel;
    lblOR2: TLabel;
    lblOR3: TLabel;
    lblOR4: TLabel;
    lblOR5: TLabel;
    lblOR6: TLabel;
    lblOR7: TLabel;
    lblOR8: TLabel;
    lblOR9: TLabel;
    lblOR10: TLabel;
    lblOR11: TLabel;
    lblOR12: TLabel;
    pnl1: TPanel;
    pnl2: TPanel;
    pnl3: TPanel;
    pnl4: TPanel;
    pnl5: TPanel;
    pnl6: TPanel;
    pnl7: TPanel;
    lblTm1: TLabel;
    lblTm2: TLabel;
    lblTm3: TLabel;
    lblTm4: TLabel;
    lblTm5: TLabel;
    lblTm6: TLabel;
    lblTm7: TLabel;
    lblTm8: TLabel;
    lblTm9: TLabel;
    lblTM10: TLabel;
    lblTm11: TLabel;
    lblTm12: TLabel;
    lblTm13: TLabel;
    ORDateTimeDlg1: TORDateTimeDlg;
    lblDt1: TLabel;
    pnlKey: TPanel;
    lblCol1: TLabel;
    lblSpec1: TLabel;
    lblCol2: TLabel;
    lblCol3: TLabel;
    lblCol4: TLabel;
    lblCol5: TLabel;
    lblCol6: TLabel;
    lblCol7: TLabel;
    lblCol8: TLabel;
    lblSpec2: TLabel;
    lblSpec3: TLabel;
    lblSpec4: TLabel;
    lblSpec5: TLabel;
    lblSpec6: TLabel;
    lblSpec7: TLabel;
    lblSpec8: TLabel;
    lbSpec: TListBox;
    lbSched: TListBox;
    lbTemp: TListBox;
    lbBlock: TListBox;
    lblCol9: TLabel;
    lblCol10: TLabel;
    lblSpec9: TLabel;
    lblSpec10: TLabel;
    Shape1: TShape;
    Shape2: TShape;
    Shape3: TShape;
    Shape4: TShape;
    Shape5: TShape;
    Shape6: TShape;
    Shape7: TShape;
    Shape8: TShape;
    Shape9: TShape;
    Shape10: TShape;
    lblOver: TLabel;
    btnSched: TButton;
    pnlSched: TPanel;
    lblSched: TLabel;
    memSched: TMemo;
    btnSave: TButton;
    btnCan: TButton;
    pnlAnes: TPanel;
    lblAnes: TLabel;
    lblAnes1: TLabel;
    lblAnes2: TLabel;
    btnCont: TButton;
    cbAnes: TORComboBox;
    cbSupvr: TORComboBox;
    lbColor: TListBox;
    lbRoom: TListBox;
    lbHeader: TListBox;
    lbData: TListBox;
    pnlCanc: TPanel;
    lblCan: TLabel;
    cbCan: TORComboBox;
    lblComm: TLabel;
    memCan: TMemo;
    btnGo: TButton;
    btnTake: TButton;
    pnlPop: TPanel;
    lblName: TLabel;
    lblProc: TLabel;
    lblCancel: TLabel;
    lblMove: TLabel;
    lblDetail: TLabel;
    pnlMove: TPanel;
    stMove: TORStaticText;
    stMove2: TORStaticText;
    stMove3: TORStaticText;
    lblNew: TORStaticText;
    btnResched: TButton;
    btnAction: TButton;
    lbMove: TListBox;
    MenuTimer: TTimer;
    bvlMove: TBevel;
    pnlRoom: TPanel;
    lbRmSchd: TORListBox;
    lblHdr: TLabel;
    btnExit: TButton;
    memSchd: TMemo;
    lblSchd: TLabel;
    lblOR13: TLabel;
    lblOR14: TLabel;
    lblNote: TLabel;
    lblNote1: TLabel;
    dbNewDt: TORDateBox;
    lblNewDt: TLabel;
    lblMove1: TLabel;
    memMove: TMemo;
    pnlOption: TPanel;
    dbSurg: TORDateBox;
    rgOpt: TRadioGroup;
    btnRef: TButton;
    btnCan1: TBitBtn;
    lblDate: TLabel;
    lblOR15: TLabel;
    btnReq: TButton;
    pnlReq: TPanel;
    lblReq: TLabel;
    lbCReq: TORListBox;
    lblKey: TLabel;
    btnQuit: TBitBtn;
    pnl8: TPanel;
    pnl9: TPanel;
    pnl10: TPanel;
    pnl11: TPanel;
    pnl12: TPanel;
    pnl13: TPanel;
    ScrollTimer: TTimer;
    btnPrint: TButton;
    lblInfo: TLabel;
    btnBlank: TButton;
    pnlDetail: TPanel;
    lbDetail: TORListBox;
    lblDet: TLabel;
    btnDet: TBitBtn;
    lblPend: TLabel;
    btnEdit: TButton;
    lbPTemp: TORListBox;
    lblEdit: TLabel;
    btnPatInq: TButton;
    procedure dbSurgChange(Sender: TObject);
    procedure Fill(ACol, ARow: integer; AColor: TColor; AStyle: TBrushStyle);
    procedure ClearCells;
    procedure SpecKey(ASpec, ASpecn: string);
    procedure KeyDisplay;
    procedure ClearKey;
    procedure drgrSchedMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure GetCase(ACol, ARow: integer);
    procedure RefreshSchedule;
    procedure DisplayColors(Alist: TListBox; Style: TBrushStyle);
    procedure btnRefClick(Sender: TObject);
    procedure rgOptClick(Sender: TObject);
    procedure drgrSchedMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    function CasePresent(ACol, ARow: integer): integer;
    procedure btnSchedClick(Sender: TObject);
    function GetTimes(ACol, num: integer): string;
    procedure btnSaveClick(Sender: TObject);
    procedure btnCanClick(Sender: TObject);
    procedure ClearSchedData;
    procedure RoomList(Room: string);
    procedure lblOR1Click(Sender: TObject);
    procedure lblOR2Click(Sender: TObject);
    procedure lblOR3Click(Sender: TObject);
    procedure lblOR4Click(Sender: TObject);
    procedure lblOR5Click(Sender: TObject);
    procedure lblOR6Click(Sender: TObject);
    procedure lblOR7Click(Sender: TObject);
    procedure lblOR8Click(Sender: TObject);
    procedure lblOR9Click(Sender: TObject);
    procedure lblOR10Click(Sender: TObject);
    procedure lblOR11Click(Sender: TObject);
    procedure lblOR12Click(Sender: TObject);
    procedure btnContClick(Sender: TObject);
    procedure btnCanc1Click(Sender: TObject);
    procedure SetHeaders;
    procedure SetRooms;
    procedure ClearFillData;
    procedure PopupMenu(ACol, ARow: integer);
    procedure btnGoClick(Sender: TObject);
    procedure btnTakeClick(Sender: TObject);
    procedure ResetCaseColor;
    procedure RedrawSchedule;
    procedure lblMoveMouseEnter(Sender: TObject);
    procedure lblMoveMouseLeave(Sender: TObject);
    procedure lblCancelMouseEnter(Sender: TObject);
    procedure lblCancelMouseLeave(Sender: TObject);
    procedure lblDetailMouseEnter(Sender: TObject);
    procedure lblDetailMouseLeave(Sender: TObject);
    procedure lblCancelClick(Sender: TObject);
    procedure lblDetailClick(Sender: TObject);
    procedure lblMoveClick(Sender: TObject);
    procedure pnlPopClick(Sender: TObject);
    procedure ClearPopMenu;
    procedure btnActionClick(Sender: TObject);
    procedure MenuTimerTimer(Sender: TObject);
    procedure btnExitClick(Sender: TObject);
    procedure lbRmSchdDblClick(Sender: TObject);
    procedure lblOR13Click(Sender: TObject);
    procedure lblOR14Click(Sender: TObject);
    procedure lblOR1MouseEnter(Sender: TObject);
    procedure lblOR1MouseLeave(Sender: TObject);
    procedure lblOR2MouseLeave(Sender: TObject);
    procedure lblOR2MouseEnter(Sender: TObject);
    procedure lblOR3MouseEnter(Sender: TObject);
    procedure lblOR3MouseLeave(Sender: TObject);
    procedure lblOR4MouseEnter(Sender: TObject);
    procedure lblOR4MouseLeave(Sender: TObject);
    procedure lblOR5MouseEnter(Sender: TObject);
    procedure lblOR5MouseLeave(Sender: TObject);
    procedure lblOR6MouseEnter(Sender: TObject);
    procedure lblOR6MouseLeave(Sender: TObject);
    procedure lblOR7MouseEnter(Sender: TObject);
    procedure lblOR7MouseLeave(Sender: TObject);
    procedure lblOR8MouseEnter(Sender: TObject);
    procedure lblOR8MouseLeave(Sender: TObject);
    procedure lblOR9MouseEnter(Sender: TObject);
    procedure lblOR9MouseLeave(Sender: TObject);
    procedure lblOR10MouseEnter(Sender: TObject);
    procedure lblOR10MouseLeave(Sender: TObject);
    procedure lblOR11MouseEnter(Sender: TObject);
    procedure lblOR11MouseLeave(Sender: TObject);
    procedure lblOR12MouseEnter(Sender: TObject);
    procedure lblOR12MouseLeave(Sender: TObject);
    procedure lblOR13MouseEnter(Sender: TObject);
    procedure lblOR13MouseLeave(Sender: TObject);
    procedure lblOR14MouseEnter(Sender: TObject);
    procedure lblOR14MouseLeave(Sender: TObject);
    procedure ClearRoomLabels;
    procedure btnReschedClick(Sender: TObject);
    procedure DisplayMove;
    procedure HideMove;
    procedure lblOR15Click(Sender: TObject);
    procedure lblOR15MouseLeave(Sender: TObject);
    procedure lblOR15MouseEnter(Sender: TObject);
    procedure btnReqClick(Sender: TObject);
    procedure lbCReqClick(Sender: TObject);
    procedure btnQuitClick(Sender: TObject);
    procedure cbAnesChange(Sender: TObject);
    procedure cbSupvrChange(Sender: TObject);
    procedure RefreshReq;
    procedure drgrSchedTopLeftChanged(Sender: TObject);
    procedure ScrollTimerTimer(Sender: TObject);
    procedure btnPrintClick(Sender: TObject);
    procedure lbCReqMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure btnDetClick(Sender: TObject);
    procedure CaseDetail(OpCase: string);
    procedure lbDetailClick(Sender: TObject);
    procedure cbCanChange(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure btnEditClick(Sender: TObject);
    function FindPM(X: integer): integer;
    procedure cbCanClick(Sender: TObject);
    procedure lblEditClick(Sender: TObject);
    procedure lblEditMouseEnter(Sender: TObject);
    procedure lblEditMouseLeave(Sender: TObject);
    procedure btnPatInqClick(Sender: TObject);
    procedure ScheduleSetUp;
  private
    { Private declarations }
  public
    { Public declarations }
    frmSched: TfrmSched;
  end;

var
  frmSched: TfrmSched;
  keyOK, tempx, tempy, tempcoorx, tempcoory, option, overlap, optkey, canckey: integer;
  pending, pendrow, pendcol1, pendcol2, start, move, coldiff, roomkey, Source, TopR, LeftC: integer;
  tempName, SchedTim1, SchedTim2, SchedRoom, SchedDate, RoomIFN, AMPM, Min, SurgDate: string;
  SchedProc, SchedSurg, SchedAtt, SchedCase, SchedPt, SchedAnes, SchedOrder, SchedLen, PtSSN: string;
  LastTopR, LastLeftC, First, CanIFN: integer;
  SurgDt: TFMDateTime;
  HiLite, LoLite: TColor;
  PopCoord: TPoint;

procedure Schedule(spifn: integer; SchedData: TStrings; Source: integer);

implementation

{$R *.dfm}

uses SCMMain, fGenPrint, fService, rLocal, fEditReq, fPatInq;

procedure Schedule(spifn: integer; SchedData: TStrings; Source: integer);
var
  J, p1, p2, p3, p4, p5, p6: integer;
begin
  frmSched := TfrmSched.Create(Application);
  if (UserMan = '') and (UserSched = '') then
    begin
      MessageDlg('You do not have the correct access to schedule cases', mtwarning, [mbOK], 0);
      Exit;
    end;
  try
    with frmSched do
    begin
      keyOK := 0;
      tempx := 0;
      tempy := 0;
      tempcoorx := 0;
      tempcoory := 0;
      tempName  := '';
      //rgOpt.ItemIndex := 1;
      option    := 1;
      move      := 0;
      roomkey   := 0;
      optkey    := Source;
      HiLite    := clMoneyGreen;
      LoLite    := cl3DLight;
      Topr      := 0;
      overlap   := 0;
      pending   := 0;
      LastTopR  := 0;
      LastLeftC := 0;
      PutFlag   := 0;
      AMPM      := 'A';
      SchedAnes := '';
      if optkey = 1 then     // from request note
        begin
          p1 := 22;
          p2 := 11;
          p3 := 12;
          p4 := 32;
          p5 := 16;
          p6 := 14;
        end;
      if optkey = 2 then     // from current request list
        begin
          p1 := 1;
          p2 := 2;
          p3 := 3;
          p4 := 4;
          p5 := 5;
          p6 := 6;
        end;
      if optkey < 3 then
        begin
          SchedProc  := SchedData.Strings[p1];
          SchedSurg  := piece(SchedData.Strings[p2], '^', 2);
          SchedAtt   := piece(SchedData.Strings[p3], '^', 2);
          SchedCase  := SchedData.Strings[p4];
          SchedPt    := piece(SchedData.Strings[0], '^', 2);
          SchedOrder := SchedData.Strings[p5];
          SchedLen   := SchedData.Strings[p6];
          if optkey < 3 then   // op date from request list
            begin
              SurgDt := StrToInt(piece(SchedData.Strings[8], '^', 1));
              SurgDate := piece(SchedData.Strings[8], '^', 2);
              dbSurg.Enabled := False;
            end;
          Caption    := 'Schedule a ' + SpecName + ' procedure for ' + SchedPt;
        end;
      if optkey = 3 then   // from Tools menu
        begin
          Caption := 'Surgery Schedule';
        end;
      if optkey = 4 then   // from direct entry
        begin
          PtName    := piece(SchedData.Strings[0], '^', 2);
          PtSSN     := piece(SchedData.Strings[0], '^', 3);
          Caption   := 'Direct Surgery Schedule entry for ' + PtName;
          SpecIFN   := StrToInt(piece(SchedData.Strings[23], '^', 1));
          SpecName  := piece(SchedData.Strings[23], '^', 2);
          SpecAbbr  := piece(SchedData.Strings[23], '^', 3);
          SpecColor := StringToColor(piece(SchedData.Strings[23], '^', 4));
        end;
      pnlKey.Visible := False;
      lbColor.Clear;
      lbRoom.Clear;
      lbHeader.Clear;
      CallV('APTWL GET COLORS', []);
      lbColor.Items := RPCBrokerV.Results;
      CallV('APTWL GET ROOMS', []);
      lbRoom.Items := RPCBrokerV.Results;
      SetRooms;
      CallV('APTWL GET HEADERS', [SiteIFN]);
      lbHeader.Items := RPCBrokerV.Results;
      start := StrToInt(lbHeader.Items[0]);
      SetHeaders;
      ClearSchedData;
      ClearFillData;
      CallV('APTWL GET PROVIDER', ['A', spifn]);
      cbAnes.Items  := RPCBrokerV.Results;
      cbSupvr.Items := RPCBrokerV.Results;
      if optkey < 3 then   // from request list
        begin
          ScheduleSetUp;
          CaseDetail(SchedCase);
        end;
      if optkey = 3 then lblInfo.Caption := '';
      if optkey = 4 then
        begin
          lbDetail.Items.Add('Patient:   ' + PtName + '   ' + PtSSN);
          lbDetail.Items.Add('Procedure:');
          lbDetail.Items.Add('                         Specialty: ' + SpecName);
          pnlDetail.Visible := True;
        end;
      Top := 40;
      //dbSurg.SetFocus;
      ShowModal;
    end;
  finally
    frmSched.Release;
  end;
end;

procedure TfrmSched.dbSurgChange(Sender: TObject);
var
  day: string;
begin
  if keyOK = 0 then
  begin
    SurgDt := dbSurg.FMDateTime;
    day := sCallV('APTWL GET DAY', [surgDt]);
    lblDt1.Caption := day + ' ' + dbSurg.Text;
    ClearCells;
    lbSpec.Clear;
    lbBlock.Clear;
    lbSched.Clear;
    ClearKey;
    pnlKey.Visible    := False;
    pnlReq.Visible    := False;
    pnlDetail.Visible := False;
    lbCReq.Items.Clear;
    lbDetail.Items.Clear;
    CallV('APTWL GET BLOCKOUT', [SurgDt, SiteIFN]);
    lbBlock.Items := RPCBrokerV.Results;
    CallV('APTWL GET SCHEDULE', [SurgDt, SiteIFN]);
    lbSched.Items := RPCBrokerV.Results;
  end;
  if (option = 0) or (option = 2) then DisplayColors(lbBlock, bsDiagCross);  // blockout schedule
  if (option = 1) or (option = 2) then DisplayColors(lbSched, bsSolid);  // case schedule
  if keyOK = 0 then KeyDisplay;
end;

procedure TfrmSched.Fill(ACol, ARow: integer; AColor: TColor; AStyle: TBrushStyle);
var
  xout: TRect;
  xcoord, ycoord: integer;
  char: string;
begin
  xout := drgrSched.CellRect(ACol, ARow);
  drgrSched.Canvas.Brush.Color := AColor;
  drgrSched.Canvas.Brush.Style := AStyle;
  drgrSched.Canvas.Fillrect(xout);
  if (overlap = 1) or (pending = 1) then
    begin
      xcoord := ACol * 13 + 2;  // 13 is column width + 1
      ycoord := ARow * 25 + 5;  // 25 is row height + 1
      if pending = 1 then char := ' *';
      if overlap = 1 then char := 'O';
      drgrSched.Canvas.TextRect(xout, xcoord, ycoord, char);
    end;
end;

procedure TfrmSched.ClearCells;
var
  J, K: integer;
begin
  for J := 0 to drgrSched.ColCount-1 do
  begin
    for K := drgrSched.TopRow to drgrSched.TopRow + 14 do Fill(J, K, clWindow, bsSolid);
  end;
end;

procedure TfrmSched.SpecKey(ASpec, ASpecn: string);
// set up color key list for specialties
var
  I, OK: integer;
begin
  OK := 0;
  for I := 0 to lbSpec.Items.Count-1 do
  begin
    if piece(lbSpec.Items[I], '^', 1) = ASpec then OK := 1;
  end;
  if OK = 0 then lbSpec.Items.Add(ASpec + '^' + ASpecn);
end;

procedure TfrmSched.KeyDisplay;
var
  I: integer;
  spIFN, spName: string;
  Color: TColor;
begin
  pnlKey.Visible := True;
  for I := 0 to lbSpec.Items.Count -1 do
  begin
    spIFN := piece(lbSpec.Items[I], '^', 1);
    spName := piece(lbSpec.Items[I], '^', 2);
    Color := StringToColor(lbColor.Items[StrToInt(spIFN)]);
    if I = 0 then
    begin
      lblCol1.Color := Color;
      shape1.Brush.Color := Color;
      shape1.Pen.Color := Color;
      shape1.Brush.Style := bsDiagCross;
      lblSpec1.Caption := spName;
    end;
    if I = 1 then
    begin
      lblCol2.Color := Color;
      shape2.Brush.Color := Color;
      shape2.Pen.Color := Color;
      shape2.Brush.Style := bsDiagCross;
      lblSpec2.Caption := spName;
    end;
    if I = 2 then
    begin
      lblCol3.Color := Color;
      shape3.Brush.Color := Color;
      shape3.Pen.Color := Color;
      shape3.Brush.Style := bsDiagCross;
      lblSpec3.Caption := spName;
    end;
    if I = 3 then
    begin
      lblCol4.Color := Color;
      shape4.Brush.Color := Color;
      shape4.Pen.Color := Color;
      shape4.Brush.Style := bsDiagCross;
      lblSpec4.Caption := spName;
    end;
    if I = 4 then
    begin
      lblCol5.Color := Color;
      shape5.Brush.Color := Color;
      shape5.Pen.Color := Color;
      shape5.Brush.Style := bsDiagCross;
      lblSpec5.Caption := spName;
    end;
    if I = 5 then
    begin
      lblCol6.Color := Color;
      shape6.Brush.Color := Color;
      shape6.Pen.Color := Color;
      shape6.Brush.Style := bsDiagCross;
      lblSpec6.Caption := spName;
    end;
    if I = 6 then
    begin
      lblCol7.Color := Color;
      shape7.Brush.Color := Color;
      shape7.Pen.Color := Color;
      shape7.Brush.Style := bsDiagCross;
      lblSpec7.Caption := spName;
    end;
    if I = 7 then
    begin
      lblCol8.Color := Color;
      shape8.Brush.Color := Color;
      shape8.Pen.Color := Color;
      shape8.Brush.Style := bsDiagCross;
      lblSpec8.Caption := spName;
    end;
    if I = 8 then
    begin
      lblCol9.Color := Color;
      shape9.Brush.Color := Color;
      shape9.Pen.Color := Color;
      shape9.Brush.Style := bsDiagCross;
      lblSpec9.Caption := spName;
    end;
    if I = 9 then
    begin
      lblCol10.Color := Color;
      shape10.Brush.Color := Color;
      shape10.Pen.Color := Color;
      shape10.Brush.Style := bsDiagCross;
      lblSpec10.Caption := spName;
    end;
  end;
  lblOver.Caption := 'O = Overlapping Cases';
  pnlKey.Visible := True;
end;

procedure TfrmSched.ClearKey;
begin
  lblCol1.Color := clWindow;
  shape1.Brush.Color := clWindow;
  shape1.Pen.Color := clWindow;
  lblSpec1.Caption := '';
  lblCol2.Color := clWindow;
  shape2.Brush.Color := clWindow;
  shape2.Pen.Color := clWindow;
  lblSpec2.Caption := '';
  lblCol3.Color := clWindow;
  shape3.Brush.Color := clWindow;
  shape3.Pen.Color := clWindow;
  lblSpec3.Caption := '';
  lblCol4.Color := clWindow;
  shape4.Brush.Color := clWindow;
  shape4.Pen.Color := clWindow;
  lblSpec4.Caption := '';
  lblCol5.Color := clWindow;
  shape5.Brush.Color := clWindow;
  shape5.Pen.Color := clWindow;
  lblSpec5.Caption := '';
  lblCol6.Color := clWindow;
  shape6.Brush.Color := clWindow;
  shape6.Pen.Color := clWindow;
  lblSpec6.Caption := '';
  lblCol7.Color := clWindow;
  shape7.Brush.Color := clWindow;
  shape7.Pen.Color := clWindow;
  lblSpec7.Caption := '';
  lblCol8.Color := clWindow;
  shape8.Brush.Color := clWindow;
  shape8.Pen.Color := clWindow;
  lblSpec8.Caption := '';
  lblCol9.Color := clWindow;
  shape9.Brush.Color := clWindow;
  shape9.Pen.Color := clWindow;
  lblSpec9.Caption := '';
  lblCol10.Color := clWindow;
  shape10.Brush.Color := clWindow;
  shape10.Pen.Color := clWindow;
  lblSpec10.Caption := '';
  lblOver.Caption := '';
end;

procedure TfrmSched.drgrSchedMouseMove(Sender: TObject; Shift: TShiftState;
  X, Y: Integer);
var
  coor: TGridCoord;
begin
  Sleep(800);
  if (x = tempx) and (y = tempy) then Exit; // check if cursor moved
  tempx := x;
  tempy := y;
  lbTemp.Clear;
  coor := drgrSched.MouseCoord(x, y);
  if (coor.x = tempcoorx) and (coor.Y = tempcoory) then Exit; // check if cursor moved in same cell
  tempcoorx := coor.x;
  tempcoory := coor.y;
  GetCase(coor.X, coor.Y);
  if lbTemp.Items.Count = 0 then Exit;
  ShowCase(lbTemp, x, y);
  keyOK := 1;
  RefreshSchedule;
  keyOK := 0;
end;

procedure TfrmSched.GetCase(ACol, ARow: integer);
var
  J, K, row, col1, col2: integer;
  data, Name, Proc, Surg, Att, Start, Stop, Specn: string;
begin
  for J := 0 to lbSched.Items.Count-1 do
  begin
    data := lbSched.Items[J];
    row  := StrToInt(piece(data, '^', 1));
    col1 := StrToInt(piece(data, '^', 2));
    col2 := StrToInt(piece(data, '^', 3));
    if row = ARow then
      if (ACol = col1) or (ACol > col1) then
        if (Acol = col2) or (Acol < col2) then
        begin
          Specn := piece(data, '^', 5);
          Name  := piece(data, '^', 7);
          if Name = tempName then Exit; // check if same case
          tempName := Name;
          Proc  := piece(data, '^', 8);
          Surg  := piece(data, '^', 9);
          Att   := piece(data, '^', 10);
          Start := piece(data, '^', 11);
          Stop  := piece(data, '^', 12);
          lbTemp.Items.Add('Times:     ' + Start + '-' + Stop);
          lbTemp.Items.Add('Patient:   ' + Name);
          lbTemp.Items.Add('Specialty: ' + Specn);
          lbTemp.Items.Add('Procedure: ' + Proc);
          lbTemp.Items.Add('Surgeon:   ' + Surg);
          lbTemp.Items.Add('Attending: ' + Att);
          Break;
        end;
  end;
end;

procedure TfrmSched.RefreshSchedule;
begin
  if (option = 0) or (option = 2) then DisplayColors(lbBlock, bsDiagCross);  // blockout schedule
  if (option = 1) or (option = 2) then DisplayColors(lbSched, bsSolid);      // case schedule
end;

procedure TfrmSched.DisplayColors(AList: TListBox; Style: TBrushStyle);
var
  SurgOR, Col, Row, Col1, Col2, J, lastRow, lastCol1, lastCol2, caseCnt: integer;
  Spec, Specn, temp: string;
  Color: TColor;
begin
  lastRow  := 0;
  lastCol1 := 0;
  lastCol2 := 0;
  caseCnt  := 0;
  for J := 0 to AList.Items.Count-1 do
    begin
      temp  := AList.Items[J];
      Row   := StrToInt(piece(temp, '^', 1));
      if Row <> lastRow then
        begin
          caseCnt := 0;
          lastRow := Row;
        end;
      Col1  := StrToInt(piece(temp, '^', 2));
      Col2  := StrToInt(piece(temp, '^', 3));
      Spec  := piece(temp, '^', 4);
      if Spec = '' then Spec := '0';
      Specn := piece(temp, '^', 5);
      if Specn = '' then Specn := 'Unknown';
      Color := StringToColor(lbColor.Items[StrToInt(Spec)]);
      caseCnt := caseCnt + 1;
      if lbSpec.Items.Count = 0 then lbSpec.Items.Add(Spec + '^' + Specn);  // initial set
      SpecKey(Spec, Specn);
      for Col := Col1 to Col2 do
        begin
          overlap := 0;  // overlapping cases flag
          if Row = lastRow then
            if caseCnt > 1 then
              if (Col = lastCol1) or (Col > lastCol1) then
                if (Col = lastCol2) or (Col < lastCol2) then overlap := 1;
          Fill(Col, Row, Color, Style);
        end;
        lastCol1 := Col1;
        lastCol2 := Col2;
    end;
  overlap := 0;
end;

procedure TfrmSched.btnRefClick(Sender: TObject);
begin
  RedrawSchedule;
  ClearSchedData;
  btnSched.Visible := False;
end;

procedure TfrmSched.rgOptClick(Sender: TObject);
begin
  option := rgOpt.ItemIndex;
  ClearCells;
  lbSpec.Items.Clear;
  ReFreshSchedule;
  ClearKey;
  KeyDisplay;
end;

procedure TfrmSched.drgrSchedMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var
  Color: TColor;
  coor: TGridCoord;
  Style: TBrushStyle;
  Col: integer;
  Btn: TMsgDlgBtn;
  J, FResult, tempCol1, tempCol2: integer;
begin
  ResetTimeOut;
  if move = 1 then
    begin
      ClearCells;
      RefreshSchedule;
      DisplayColors(lbTemp, bsDiagCross);
      coor := drgrSched.MouseCoord(x, y);
      pendrow  := coor.Y;
      pendcol1 := coor.X;
      pendcol2 := pendcol1 + coldiff;
      for J := pendcol1 to pendcol2 do
        begin
          FResult := CasePresent(J, coor.Y);
          if FResult = 1 then
            begin
              if MessageDlg('The case you are moving will not fit in' + CRLF +
                'the room and times you have selected.', mtwarning, [mbOK, mbIgnore], 0) = mrOK then
                begin
                  RefreshSchedule;
                  DisplayColors(lbTemp, bsDiagCross);
                  move := 0;
                  Exit;
                end;
              RefreshSchedule;
            end;
          if FResult = 2 then Break;
        end;
      pending := 1;
      lbMove.Clear;
      lbMove.Items.Add(IntToStr(pendrow) + '^' + IntToStr(pendcol1) + '^' + IntToStr(pendcol2) + '^' +
        piece(lbTemp.Items[0], '^', 4) + '^' + piece(lbTemp.Items[0], '^', 5));
      DisplayColors(lbMove, bsSolid);
      pending := 0;
      SchedTim1 := GetTimes(pendcol1, 1);
      SchedTim2 := GetTimes(pendcol2, 2);
      SchedRoom := piece(lbRoom.Items[pendrow + 1], '^', 2);
      RoomIFN   := piece(lbRoom.Items[pendrow + 1], '^', 1);      stMove3.Visible    := True;
      lblNew.Caption     := SchedRoom + '  ' + SchedTim1 + '-' + SchedTim2;
      DisplayMove;
      memMove.Clear;
      Exit
    end;
  lbTemp.Clear;
  coor := drgrSched.MouseCoord(x, y);
  if CasePresent(coor.X, coor.Y) = 1 then
    begin
      PopupMenu(coor.X, coor.Y);
      Exit;
    end;
  if optkey = 3 then Exit;  // only edit if from Tools menu
  if SurgDt < Today then
    begin
      MessageDlg('Action not appropriate for days in the past!', mtwarning, [mbOK], 0);
      RefreshSchedule;
      Exit;
    end;
  Style := bsSolid;
  Color := SpecColor;
  overlap := 0;
  pending := 1;
  btnSched.Visible := True;
  if coor.Y = pendrow then
    begin
      if Button = mbLeft then
        begin
          if coor.X > pendcol1 then pendcol2 := coor.X;
          if coor.X < pendcol1 then pendcol1 := coor.X;
        end;
      if Button = mbRight then
        begin
          if (coor.X > pendcol1) and (coor.X < pendcol2) then Exit;
          tempCol1 := pendcol1;
          tempCol2 := pendcol2;
          pendcol1 := coor.X;
          pendcol2 := coor.X;
          Color    := clWindow;
          pending  := 0;
        end;
    end
  else
    begin
      pendrow  := coor.Y;
      pendcol1 := coor.X;
      pendcol2 := coor.X;
    end;
  for Col := pendcol1 to pendcol2 do Fill(Col, coor.Y, Color, Style);
  pending  := 0;
  if Button = mbRight then
    begin
      if coor.X = tempcol1 then
        begin
          pendcol1 := tempCol1 + 1;
          pendcol2 := tempCol2;
        end;
      if coor.X = tempcol2 then
        begin
          pendcol1 := tempCol1;
          pendcol2 := tempCol2 - 1;
        end;
    end;
  SchedTim1 := GetTimes(pendcol1, 1);
  SchedTim2 := GetTimes(pendcol2, 2);
  SchedRoom := piece(lbRoom.Items[pendrow + 1], '^', 2);
  RoomIFN   := piece(lbRoom.Items[pendrow + 1], '^', 1);
  if optkey < 3 then SchedDate := FloatToStr(Surgdt)
  else SchedDate := FloatToStr(dbSurg.FMDateTime);
end;

function TfrmSched.CasePresent(ACol, ARow: integer): integer;
// is cell taken by existing case?
var
  J, row, col1, col2, oldrow, oldcol1, oldcol2, olddiff: integer;
  data: string;
begin
  if move = 0 then lbTemp.Clear;
  if move = 1 then   // original position of case
    begin
      oldrow  := StrToInt(piece(lbTemp.Items[0], '^', 1));
      oldcol1 := StrToInt(piece(lbTemp.Items[0], '^', 2));
      oldcol2 := StrToInt(piece(lbTemp.Items[0], '^', 3));
      olddiff := oldcol2 - oldcol1;
    end;
  Result := 0;
  for J := 0 to lbSched.Items.Count-1 do
  begin
    data := lbSched.Items[J];
    row  := StrToInt(piece(data, '^', 1));
    if row = ARow then
      begin
        col1    := (StrToInt(piece(data, '^', 2))) - 1;
        col2    := (StrToInt(piece(data, '^', 3))) + 1;
        coldiff := (col2 - 1) - (col1 + 1);
        if Arow = oldrow then    // allow new position to overlap old
          begin
            if (ACol > oldcol1) and (ACol < oldcol2) then
              begin
                Result := 2;
                Break;
              end;
            if (ACol > (oldcol1 - olddiff)) and (ACol < oldcol1) then
              begin
                Result := 2;
                Break;
              end;
          end;
        if (ACol > col1) and (ACol < col2) then
          begin
            Result := 1;
            if move = 0 then
              begin
                lbTemp.Items.Add(data);
                //coldiff := (col2 -1) - (col1 +1);
              end;
            Break;
          end;
      end;
  end;
end;

procedure TfrmSched.btnSchedClick(Sender: TObject);
var
  Late: string;
begin
  ClearFillData;
  Late := sCallV('APTWL IS TOO LATE', [SurgDt]);
  if piece(Late, '^', 1) = '1' then
    begin
      if MessageDlg('It is too late to schedule a procedure' + CRLF +
        'for the date selected.', mtwarning, [mbOK, mbIgnore], 0) = mrOK then
        begin
          ClearCells;
          RefreshSchedule;
          btnSched.Visible := False;
          Exit;
        end;
      RefreshSchedule;
    end;
  if (piece(Late, '^', 1) = '2') or (piece(Late, '^', 1) = '3') then
    begin
      if MessageDlg('Scheduling not allowed on ' + piece(Late, '^', 2), mtwarning, [mbOK, mbIgnore], 0) = mrOK then
        begin
          ClearCells;
          RefreshSchedule;
          btnSched.Visible := False;
          Exit;
        end;
    end;
  //pnlAnes.Visible  := True;
  //pnlAnes.BringToFront;
  //memSched.Clear;
  btnContClick(Self);
end;

function TfrmSched.GetTimes(ACol, num: integer): string;
// convert selected boxes to schedule times
var
  time, hour, min: string;
  xhour: integer;
begin
  ACol := ACol + num;
  time := FloatToStr(start + (Acol / 4));  // 1-12-07
  hour := piece(time, '.', 1);
  if StrToInt(hour) < 10 then hour := '0' + hour;
  min  := piece(time, '.', 2);
  if min = '' then
    begin
      xhour  := StrToInt(hour) -1;
      hour   := IntToStr(xhour);
      Result := hour + ':45';
    end;
  if min = '25' then Result := hour + ':' + '00';
  if min = '5' then Result := hour + ':' + '15';
  if min = '75' then Result := hour + ':' + '30';
end;

procedure TfrmSched.btnSaveClick(Sender: TObject);
var
  Style: TBrushStyle;
  Color: TColor;
  Col, SchedCC: integer;
  Success, CCase: string;
begin
  SchedCC := 0;
  CCase := sCallV('APTWL CONCURRENT CASE', [SchedCase]);
  if piece(CCase, '^', 1) = '1' then
    begin
      if MessageDlg('There is a concurrent case associated with this operation:' + CRLF +
        '  ' + piece(CCase, '^' ,2) + CRLF + 'Do you want to schedule it for the same time?', mtConfirmation, [mbYes, mbNo], 0) = mrYes then SchedCC := 1;
    end;
  Success := sCallV('APTWL PUT SCHEDULE', [SchedCase, SchedDate, SchedTim1, SchedTim2, RoomIFN, memSchd.Lines, SchedCC]);
  if piece(Success, '^', 1) = '1' then
    begin
      pending := 0;
      overlap := 0;
      Style   := bsSolid;
      Color   := SpecColor;
      for Col := pendcol1 to pendcol2 do Fill(Col, pendrow, Color, Style);
      MessageDlg('Case #' + SchedCase + ' on ' + SchedPt + CRLF +
        'was scheduled successfully.' + CRLF + '  SCM Acc #: ' + SpecAbbr + ' ' +
        piece(Success, '^', 3), mtinformation, [mbOK], 0);
      RedrawSchedule;
      RefreshReq;
      ClearKey;
      KeyDisplay;
      lblInfo.Caption := '';
      pnlDetail.Visible := False;
      if optkey = 1 then PutFlag := 1;  // from note request
      if optkey > 2 then pnlReq.Visible := True;
    end;
  if piece(Success, '^', 1) = '0' then
    begin
      MessageDlg('Case #' + SchedCase + ' on ' + SchedPt + CRLF +
        'could not be scheduled.' + CRLF + '  Reason: ' + piece(Success, '^', 2), mtwarning, [mbOK], 0);
      RefreshSchedule;
    end;
  btnCanClick(Self);
end;

procedure TfrmSched.btnCanClick(Sender: TObject);
begin
  pnlSched.Visible := False;
  btnSched.Visible := False;
  cbAnes.Text      := '';
  cbSupvr.Text     := '';
  ClearSchedData;
  ClearCells;
  RefreshSchedule;
end;

procedure TfrmSched.ClearSchedData;
begin
  SchedTim1 := '';
  SchedTim2 := '';
  SchedRoom := '';
  SchedDate := '';
end;

procedure TfrmSched.RoomList(Room: string);
var
  J: integer;
begin
  pnlRoom.BringToFront;
  lbRmSchd.Clear;
  CallV('APTWL GET ROOM SCHED', [piece(Room, '^', 1), SurgDt, SiteIFN]);
  lbRmSchd.Items  := RPCBrokerV.Results;
  lblHdr.Caption  := 'Schedule for ' + piece(Room, '^', 2);
  pnlRoom.Visible := True;
end;

procedure TfrmSched.lblOR1Click(Sender: TObject);
begin
  ClearRoomLabels;
  lblOR1.Color := LoLite;
  lblOR1.Font.Color := clRed;
  pnlRoom.Top := lblOR1.Top + 25;
  RoomList(lbRoom.Items[1 + TopR]);
  roomkey := 1;
end;

procedure TfrmSched.lblOR2Click(Sender: TObject);
begin
  ClearRoomLabels;
  lblOR2.Color := LoLite;
  lblOR2.Font.Color := clRed;
  pnlRoom.Top := lblOR2.Top + 25;
  RoomList(lbRoom.Items[2 + TopR]);
  roomkey := 2;
end;

procedure TfrmSched.lblOR3Click(Sender: TObject);
begin
  ClearRoomLabels;
  lblOR3.Color := LoLite;
  lblOR3.Font.Color := clRed;
  pnlRoom.Top := lblOR3.Top + 25;
  RoomList(lbRoom.Items[3 + TopR]);
  roomkey := 3;
end;

procedure TfrmSched.lblOR4Click(Sender: TObject);
begin
  ClearRoomLabels;
  lblOR4.Color := LoLite;
  lblOR4.Font.Color := clRed;
  pnlRoom.Top := lblOR4.Top + 25;
  RoomList(lbRoom.Items[4 + TopR]);
  roomkey := 4;
end;

procedure TfrmSched.lblOR5Click(Sender: TObject);
begin
  ClearRoomLabels;
  lblOR5.Color := LoLite;
  lblOR5.Font.Color := clRed;
  pnlRoom.Top := lblOR5.Top + 25;
  RoomList(lbRoom.Items[5 + TopR]);
  roomkey := 5;
end;

procedure TfrmSched.lblOR6Click(Sender: TObject);
begin
  ClearRoomLabels;
  lblOR6.Color := LoLite;
  lblOR6.Font.Color := clRed;
  pnlRoom.Top := lblOR6.Top + 25;
  RoomList(lbRoom.Items[6 + TopR]);
  roomkey := 6;
end;

procedure TfrmSched.lblOR7Click(Sender: TObject);
begin
  ClearRoomLabels;
  lblOR7.Color := LoLite;
  lblOR7.Font.Color := clRed;
  pnlRoom.Top := lblOR7.Top + 25;
  RoomList(lbRoom.Items[7 + TopR]);
  roomkey := 7;
end;

procedure TfrmSched.lblOR8Click(Sender: TObject);
begin
  ClearRoomLabels;
  lblOR8.Color := LoLite;
  lblOR8.Font.Color := clRed;
  pnlRoom.Top := lblOR8.Top + 25;
  RoomList(lbRoom.Items[8 + TopR]);
  roomkey := 8;
end;

procedure TfrmSched.lblOR9Click(Sender: TObject);
begin
  ClearRoomLabels;
  lblOR9.Color := LoLite;
  lblOR9.Font.Color := clRed;
  pnlRoom.Top := lblOR9.Top + 25;
  RoomList(lbRoom.Items[9 + TopR]);
  roomkey := 9;
end;

procedure TfrmSched.lblOR10Click(Sender: TObject);
begin
  ClearRoomLabels;
  lblOR10.Color := LoLite;
  lblOR10.Font.Color := clRed;
  pnlRoom.Top := lblOR10.Top + 25;
  RoomList(lbRoom.Items[10 + TopR]);
  roomkey := 10;
end;

procedure TfrmSched.lblOR11Click(Sender: TObject);
begin
  ClearRoomLabels;
  lblOR11.Color := LoLite;
  lblOR11.Font.Color := clRed;
  pnlRoom.Top := lblOR11.Top + 25;
  RoomList(lbRoom.Items[11 + TopR]);
  roomkey := 11;
end;

procedure TfrmSched.lblOR12Click(Sender: TObject);
begin
  ClearRoomLabels;
  lblOR12.Color := LoLite;
  lblOR12.Font.Color := clRed;
  pnlRoom.Top := lblOR12.Top + 25;
  RoomList(lbRoom.Items[12 + TopR]);
  roomkey := 12;
end;

procedure TfrmSched.btnContClick(Sender: TObject);
var
  OpDate: string;
begin
  if optkey < 3 then OpDate := SurgDate
  else OpDate := dbSurg.Text;
  //pnlAnes.Visible  := False;
  pnlSched.Visible := True;
  pnlSched.BringToFront;
  memSched.Lines.Clear;
  memSched.Lines.Add('Patient:   ' + SchedPt);  //+ '   ' + Patient.SSN)
  memSched.Lines.Add('Specialty: ' + SpecName);
  memSched.Lines.Add('Procedure: ' + SchedProc);
  memSched.Lines.Add('Op Date:   ' + OpDate);
  memSched.Lines.Add('Suite:       ' + SchedRoom);
  memSched.Lines.Add('Times:      ' + SchedTim1 + ' - ' + SchedTim2);
  memSched.Lines.Add('Surgeon:   ' + SchedSurg);
  memSched.Lines.Add('Attending: ' + SchedAtt);
  memSched.Lines.Add('Prin Anes: ' + SchedAnes);
  // memSched.Lines.Add('Case #:    ' + SchedCase);
end;

procedure TfrmSched.btnCanc1Click(Sender: TObject);
begin
  Close;
end;

procedure TfrmSched.SetHeaders;
// schedule headers in hours
var
  Hr, Head: integer;
  X: string;
begin
  if (drgrSched.LeftCol >0) and (drgrSched.LeftCol = LastLeftC) then Exit;
  LeftC := drgrSched.LeftCol;
  X   := sCallV('APTWL GET DIV', [LeftC, 4]);
  Hr  := 0;
  if piece(X, '.', 1) <> '' then Hr := StrToInt(piece(X, '.', 1));
  Min := '';
  if piece(X, '.', 2) <> '' then Min := piece(X, '.', 2);
  if Min = '25' then Min := '15';
  if Min = '5'  then Min := '30';
  if Min = '75' then Min := '45';
  if Min <> '' then Min := ':' + Min;
  First := Start + Hr;  // raw hour
  if First < 12 then AMPM := 'A';
  if (First > 11) and (First < 24) then AMPM := 'P';
  if First > 23 then AMPM := 'A';
  Head := Start + Hr;
  if Head > 12 then Head := 1;
  lblTm1.Caption  := IntToStr(Head) + Min + AMPM;
  Head := FindPM(Head);
  lblTm2.Caption  := IntToStr(Head) + Min + AMPM;
  Head := FindPM(Head);
  lblTm3.Caption  := IntToStr(Head) + Min + AMPM;
  Head := FindPM(Head);
  lblTm4.Caption  := IntToStr(Head) + Min + AMPM;
  Head := FindPM(Head);
  lblTm5.Caption  := IntToStr(Head) + Min + AMPM;
  Head := FindPM(Head);
  lblTm6.Caption  := IntToStr(Head) + Min + AMPM;
  Head := FindPM(Head);
  lblTm7.Caption  := IntToStr(Head) + Min + AMPM;
  Head := FindPM(Head);
  lblTm8.Caption  := IntToStr(Head) + Min + AMPM;
  Head := FindPM(Head);
  lblTm9.Caption  := IntToStr(Head) + Min + AMPM;
  Head := FindPM(Head);
  lblTm10.Caption := IntToStr(Head) + Min + AMPM;
  Head := FindPM(Head);
  lblTm11.Caption := IntToStr(Head) + Min + AMPM;
  Head := FindPM(Head);
  lblTm12.Caption := IntToStr(Head) + Min + AMPM;
  Head := FindPM(Head);
  lblTm13.Caption := IntToStr(Head) + Min + AMPM;
  LastLeftC := drgrSched.LeftCol;
end;

procedure TfrmSched.SetRooms;
var
  I: integer;
begin
  if (drgrSched.TopRow > 0) and (drgrSched.TopRow = LastTopR) then Exit;
  lblOR1.Caption  := '';
  lblOR2.Caption  := '';
  lblOR3.Caption  := '';
  lblOR4.Caption  := '';
  lblOR5.Caption  := '';
  lblOR6.Caption  := '';
  lblOR7.Caption  := '';
  lblOR8.Caption  := '';
  lblOR9.Caption  := '';
  lblOR10.Caption := '';
  lblOR11.Caption := '';
  lblOR12.Caption := '';
  lblOR13.Caption := '';
  lblOR14.Caption := '';
  lblOR15.Caption := '';
  TopR := drgrSched.TopRow;
  for I := 1 to lbRoom.Items.Count-1 do
    begin
      if I = 1 then lblOR1.Caption   := piece(lbRoom.Items[I + TopR], '^', 2);
      if I = 2 then lblOR2.Caption   := piece(lbRoom.Items[I + TopR], '^', 2);
      if I = 3 then lblOR3.Caption   := piece(lbRoom.Items[I + TopR], '^', 2);
      if I = 4 then lblOR4.Caption   := piece(lbRoom.Items[I + TopR], '^', 2);
      if I = 5 then lblOR5.Caption   := piece(lbRoom.Items[I + TopR], '^', 2);
      if I = 6 then lblOR6.Caption   := piece(lbRoom.Items[I + TopR], '^', 2);
      if I = 7 then lblOR7.Caption   := piece(lbRoom.Items[I + TopR], '^', 2);
      if I = 8 then lblOR8.Caption   := piece(lbRoom.Items[I + TopR], '^', 2);
      if I = 9 then lblOR9.Caption   := piece(lbRoom.Items[I + TopR], '^', 2);
      if I = 10 then lblOR10.Caption := piece(lbRoom.Items[I + TopR], '^', 2);
      if I = 11 then lblOR11.Caption := piece(lbRoom.Items[I + TopR], '^', 2);
      if I = 12 then lblOR12.Caption := piece(lbRoom.Items[I + TopR], '^', 2);
      if I = 13 then lblOR13.Caption := piece(lbRoom.Items[I + TopR], '^', 2);
      if I = 14 then lblOR14.Caption := piece(lbRoom.Items[I + TopR], '^', 2);
      if I = 15 then lblOR15.Caption := piece(lbRoom.Items[I + TopR], '^', 2);
    end;
  LastTopR := TopR;
end;

procedure TfrmSched.ClearFillData;
begin
  pendrow   := -1;
  pendcol1  := -1;
  pendcol2  := -1;
end;

procedure TfrmSched.PopupMenu(Acol, ARow: integer);
var
  J, K, row, col1, col2: integer;
  data, Name, Proc, Surg, Att, Start, Stop, Specn: string;
begin
  lbData.Clear;
  data  := lbTemp.Items[0];
  Specn := piece(data, '^', 5);
  SchedCase  := piece(data, '^', 6);
  SchedPt    := piece(data, '^', 7);
  SchedProc  := piece(data, '^', 8);
  Surg  := piece(data, '^', 9);
  Att   := piece(data, '^', 10);
  Start := piece(data, '^', 11);
  Stop  := piece(data, '^', 12);
  lbData.Items.Add('   ');
  lbData.Items.Add('  Times:     ' + Start + '-' + Stop);
  lbData.Items.Add('  Patient:   ' + SchedPt);
  lbData.Items.Add('  Specialty: ' + Specn);
  lbData.Items.Add('  Procedure: ' + SchedProc);
  lbData.Items.Add('  Surgeon:   ' + Surg);
  lbData.Items.Add('  Attending: ' + Att);
  lbData.Items.Add('  Case #:    ' + SchedCase);
  PopCoord        := Mouse.CursorPos;
  pnlPop.Top      := PopCoord.Y - 100;
  pnlPop.Left     := PopCoord.X - 190;
  if pnlPop.Left > 530 then pnlPop.Left := 530;
  lblName.Caption := SchedPt;
  lblProc.Caption := SchedProc;
  pnlPop.Visible  := True;
  pnlPop.BringToFront;
  //RefreshSchedule;
  DisplayColors(lbTemp, bsDiagCross);
  MenuTimer.Enabled := True;
end;

procedure TfrmSched.btnGoClick(Sender: TObject);
var
  Success, Add, Text: string;
  Result: integer;
begin
  // CancKey = 1   before cutoff, remove for schedule, maintain request
  //         = 2   after cutoff, cancel schedule
  //         = 3   after cutoff, cancel schedule, new request
  if (CancKey > 1) and (cbCan.Text = '') then
    begin
      MessageDlg('Please enter a cancellation reason', mterror, [mbOK], 0);
      RefreshSchedule;
      Exit;
    end;
  if (CancKey <> 2) and (dbNewDt.Text = '') then
    begin
      MessageDlg('Please enter a new Request date', mterror, [mbOK], 0);
      RefreshSchedule;
      Exit;
    end;
  Success := sCallV('APTWL CANCEL SCHED', [SchedCase, CanIFN, dbNewDt.FMDateTime, CancKey, memCan.Lines]);
  if piece(Success, '^', 1) = '1' then
    begin
      Add  := '';
      Text := '';
      if CancKey = 3 then Add := ' and a new Request created (Case #' + piece(Success, '^', 4) + ')';
      if CancKey <> 1 then MessageDlg('Case #' + SchedCase + ' for ' + SchedPt + CRLF +
        'has been cancelled' + Add + CRLF + '  Reason: ' + cbCan.Text + CRLF +
        '  Procedure: ' + SchedProc, mtinformation, [mbOK], 0);
      if CancKey = 1 then MessageDlg('Case #' + SchedCase + ' for ' + SchedPt + CRLF +
        ' has been removed from the schedule' + CRLF + '  Procedure: ' + SchedProc, mtinformation, [mbOK], 0);
      if piece(Success, '^', 2) = '1' then
        begin
          if CancKey = 1 then Text := 'remove it from the schedule'
          else Text := 'cancel it';
          Result := MessageDlg('There is a concurrent case associated with this operation.' + CRLF + 'Do you want to ' + Text + ' also?',
            mtinformation, [mbYes, mbNo], 0);
          if Result = 6 then  //  6 = mrYes
            begin
              Success := sCallV('APTWL CANCEL CC', [SchedCase, CanIFN, dbNewDt.FMDateTime, CancKey]);
              if piece(Success, '^', 1) = '1' then MessageDlg('Concurrent case #' + piece(Success, '^', 2)
                + ' was successfully removed/cancelled', mtinformation, [mbOK], 0)
              else MessageDlg('Concurrent case cancel was not successful', mtwarning, [mbOK], 0);
            end
          else
            begin
              Success := sCallV('APTWL ISOLATE CC', [SchedCase, CancKey]);
              if piece(Success, '^', 1) = '1' then MessageDlg('Concurrent case #' + piece(Success, '^', 2)
                + ' was successfully isolated', mtinformation, [mbOK], 0)
              else MessageDlg('Concurrent case isolation was not successful', mtwarning, [mbOK], 0);
            end;
        end;
      btnTakeClick(Self);
      RedrawSchedule;
      RefreshReq;  // request list
      ClearKey;
      KeyDisplay;
      Exit;
    end;
  if piece(Success, '^', 1) = '0' then
    begin
      MessageDlg('Cancelling Case #' + SchedCase + ' was not successful.' + CRLF +
        '  Reason: ' + piece(Success, '^', 2), mtwarning, [mbOK], 0);
      RefreshSchedule;
      pnlCanc.Visible := False;
    end;
end;

procedure TfrmSched.btnTakeClick(Sender: TObject);
begin
  pnlCanc.Visible := False;
  ResetCaseColor;
end;

procedure TfrmSched.ResetCaseColor;
begin
  DisplayColors(lbTemp, bsSolid);
end;

procedure TfrmSched.RedrawSchedule;
begin
  ClearCells;
  lbSched.Clear;
  CallV('APTWL GET SCHEDULE', [SurgDt, SiteIFN]);
  lbSched.Items := RPCBrokerV.Results;
  if (option = 0) or (option = 2) then DisplayColors(lbBlock, bsDiagCross);  // blockout schedule
  if (option = 1) or (option = 2) then DisplayColors(lbSched, bsSolid);  // case schedule
end;

procedure TfrmSched.lblMoveMouseEnter(Sender: TObject);
begin
  lblMove.Color := clMoneyGreen;
end;

procedure TfrmSched.lblMoveMouseLeave(Sender: TObject);
begin
  lblMove.Color := clMedGray;
end;

procedure TfrmSched.lblCancelMouseEnter(Sender: TObject);
begin
  lblCancel.Color := clMoneyGreen;
end;

procedure TfrmSched.lblCancelMouseLeave(Sender: TObject);
begin
  lblCancel.Color := clMedGray;
end;

procedure TfrmSched.lblDetailMouseEnter(Sender: TObject);
begin
  lblDetail.Color := clMoneyGreen;
end;

procedure TfrmSched.lblDetailMouseLeave(Sender: TObject);
begin
  lblDetail.Color := clMedGray;
end;

procedure TfrmSched.lblCancelClick(Sender: TObject);
var
  Late: string;
begin
  if dbSurg.FMDateTime < Today then
    begin
      MessageDlg('Action not appropriate for days in the past!', mtwarning, [mbOK], 0);
      RefreshSchedule;
      Exit;
    end;
  ClearPopMenu;
  if sCallV('APTWL HAS STARTED', [SchedCase]) = '1' then
    begin
      MessageDlg('This operation (Case #' + SchedCase + ') already has a' + CRLF +
        'start time and cannot be cancelled.', mtwarning, [mbOK], 0);
      RefreshSchedule;
      Exit;
    end;
  lblNote1.Caption := '';
  Late := sCallV('APTWL IS TOO LATE', [SurgDt]);
  if piece(Late, '^', 1) = '0' then  // before cut-off
    begin
      lblNote.Caption  := 'Case #' + SchedCase + ' will be removed from the schedule';
      lblNote1.Caption := 'and made into a request again.';
      lblCan.Visible   := False;
      cbCan.Visible    := False;
      lblNewDt.Visible := True;
      dbNewDT.Visible  := True;
      pnlCanc.Visible  := True;
      lblComm.Caption  := 'Remove Comments:';
      memCan.Clear;
      CancKey          := 1;
    end;
  if piece(Late, '^', 1) = '1' then  // after cut-off
    begin
      lblNote.Caption := 'Cancel Case #' + SchedCase + ' on ' + SchedPt;
      CallV('APTWL GET CANCEL REASON', []);
      cbCan.Items := RPCBrokerV.Results;
      pnlCanc.Visible  := True;
      lblCan.Visible   := True;
      cbCan.Visible    := True;
      lblComm.Caption  := 'Cancellation Comments:';
      lblNewDt.Visible := False;
      dbNewDt.Visible  := False;
      CancKey          := 2;
      if MessageDlg('Do you want to create a new Request' + CRLF + 'for this cancelled case?', mtconfirmation, [mbYes, mbNo], 0) = mrYes then
        begin
          lblNewDt.Visible := True;
          dbNewDt.Visible  := True;
          CancKey          := 3;
        end;
      RefreshSchedule;
      DisplayColors(lbTemp, bsDiagCross);
    end;
end;

procedure TfrmSched.lblDetailClick(Sender: TObject);
var
  Mcoord: TPoint;
begin
  ClearPopMenu;
  Mcoord := Mouse.CursorPos;
  ShowCase(lbData, Mcoord.X - 100, Mcoord.Y - 90);
  RefreshSchedule;
end;

procedure TfrmSched.lblMoveClick(Sender: TObject);
begin
  if dbSurg.FMDateTime < Today then
    begin
      MessageDlg('Action not appropriate for days in the past!', mtwarning, [mbOK], 0);
      RefreshSchedule;
      Exit;
    end;
  pnlMove.Visible := True;
  HideMove;
  ClearPopMenu;
  move := 1;
end;

procedure TfrmSched.pnlPopClick(Sender: TObject);
begin
  pnlPop.Visible := False;
  RefreshSchedule;
  MenuTimer.Enabled := False;
end;

procedure TfrmSched.ClearPopMenu;
begin
  pnlPop.Visible := False;
  RefreshSchedule;
  DisplayColors(lbTemp, bsDiagCross);
  MenuTimer.Enabled := False;
end;

procedure TfrmSched.btnActionClick(Sender: TObject);
begin
  pending := 0;
  move    := 0;
  ClearCells;
  RefreshSchedule;
  stMove3.Visible    := False;
  lblNew.Visible     := False;
  btnResched.Visible := False;
  btnAction.Visible  := False;
  pnlMove.Visible    := False;
  bvlMove.Visible    := False;
end;

procedure TfrmSched.MenuTimerTimer(Sender: TObject);
begin
  MenuTimer.Enabled := False;
  pnlPop.Visible    := False;
  ClearCells;
  RefreshSchedule;
end;

procedure TfrmSched.btnExitClick(Sender: TObject);
begin
  pnlRoom.Visible := False;
  ClearRoomLabels;
  roomkey := 0;
  RefreshSchedule;
end;

procedure TfrmSched.lbRmSchdDblClick(Sender: TObject);
var
  detcase: string;
begin
  if lbRmSchd.ItemIndex <2 then Exit;
  detcase := piece(lbRmSchd.Items[lbRmSchd.ItemIndex], '^', 8);
  CallV('APTWL GET REQ DETAIL', [detcase, 'R']);
  ReportBox(RPCBrokerV.Results, 'Surgery Case Detail for ' + piece(lbRmSchd.Items[lbRmSchd.ItemIndex], '^', 3), True);
  RefreshSchedule;
end;

procedure TfrmSched.lblOR13Click(Sender: TObject);
begin
  ClearRoomLabels;
  lblOR13.Color := LoLite;
  lblOR13.Font.Color := clRed;
  pnlRoom.Top := lblOR13.Top + 25;
  RoomList(lbRoom.Items[13 + TopR]);
  roomkey := 13;
end;

procedure TfrmSched.lblOR14Click(Sender: TObject);
begin
  ClearRoomLabels;
  lblOR14.Color := LoLite;
  lblOR14.Font.Color := clRed;
  pnlRoom.Top := lblOR14.Top + 25;
  RoomList(lbRoom.Items[14 + TopR]);
  roomkey := 14;
end;

procedure TfrmSched.lblOR1MouseEnter(Sender: TObject);
begin
  lblOR1.Color := HiLite;
end;

procedure TfrmSched.lblOR1MouseLeave(Sender: TObject);
begin
  lblOR1.Color := LoLite;
end;

procedure TfrmSched.lblOR2MouseLeave(Sender: TObject);
begin
  lblOR2.Color := LoLite;
end;

procedure TfrmSched.lblOR2MouseEnter(Sender: TObject);
begin
  lblOR2.Color := HiLite;
end;

procedure TfrmSched.lblOR3MouseEnter(Sender: TObject);
begin
  lblOR3.Color := HiLite;
end;

procedure TfrmSched.lblOR3MouseLeave(Sender: TObject);
begin
  lblOR3.Color := LoLite;
end;

procedure TfrmSched.lblOR4MouseEnter(Sender: TObject);
begin
  lblOR4.Color := HiLite;
end;

procedure TfrmSched.lblOR4MouseLeave(Sender: TObject);
begin
  lblOR4.Color := LoLite;
end;

procedure TfrmSched.lblOR5MouseEnter(Sender: TObject);
begin
  lblOR5.Color := HiLite;
end;

procedure TfrmSched.lblOR5MouseLeave(Sender: TObject);
begin
  lblOR5.Color := LoLite;
end;

procedure TfrmSched.lblOR6MouseEnter(Sender: TObject);
begin
  lblOR6.Color := HiLite;
end;

procedure TfrmSched.lblOR6MouseLeave(Sender: TObject);
begin
  lblOR6.Color := LoLite;
end;

procedure TfrmSched.lblOR7MouseEnter(Sender: TObject);
begin
  lblOR7.Color := HiLite;
end;

procedure TfrmSched.lblOR7MouseLeave(Sender: TObject);
begin
  lblOR7.Color := LoLite;
end;

procedure TfrmSched.lblOR8MouseEnter(Sender: TObject);
begin
  lblOR8.Color := HiLite;
end;

procedure TfrmSched.lblOR8MouseLeave(Sender: TObject);
begin
  lblOR8.Color := LoLite;
end;

procedure TfrmSched.lblOR9MouseEnter(Sender: TObject);
begin
  lblOR9.Color := HiLite;
end;

procedure TfrmSched.lblOR9MouseLeave(Sender: TObject);
begin
  lblOR9.Color := LoLite;
end;

procedure TfrmSched.lblOR10MouseEnter(Sender: TObject);
begin
  lblOR10.Color := HiLite;
end;

procedure TfrmSched.lblOR10MouseLeave(Sender: TObject);
begin
  lblOR10.Color := LoLite;
end;

procedure TfrmSched.lblOR11MouseEnter(Sender: TObject);
begin
  lblOR11.Color := HiLite;
end;

procedure TfrmSched.lblOR11MouseLeave(Sender: TObject);
begin
  lblOR11.Color := LoLite;
end;

procedure TfrmSched.lblOR12MouseEnter(Sender: TObject);
begin
  lblOR12.Color := HiLite;
end;

procedure TfrmSched.lblOR12MouseLeave(Sender: TObject);
begin
  lblOR12.Color := LoLite;
end;

procedure TfrmSched.lblOR13MouseEnter(Sender: TObject);
begin
  lblOR13.Color := HiLite;
end;

procedure TfrmSched.lblOR13MouseLeave(Sender: TObject);
begin
  lblOR13.Color := LoLite;
end;

procedure TfrmSched.lblOR14MouseEnter(Sender: TObject);
begin
  lblOR14.Color := HiLite;
end;

procedure TfrmSched.lblOR14MouseLeave(Sender: TObject);
begin
  lblOR14.Color := LoLite;
end;

procedure TfrmSched.ClearRoomLabels;
begin
  if roomkey = 1 then
    begin
      lblOR1.Font.Color := clWindowText;
      Exit;
    end;
  if roomkey = 2 then
    begin
      lblOR2.Font.Color := clWindowText;
      Exit;
    end;
  if roomkey = 3 then
    begin
      lblOR3.Font.Color := clWindowText;
      Exit;
    end;
  if roomkey = 4 then
    begin
      lblOR4.Font.Color := clWindowText;
      Exit;
    end;
  if roomkey = 5 then
    begin
      lblOR5.Font.Color := clWindowText;
      Exit;
    end;
  if roomkey = 6 then
    begin
      lblOR6.Font.Color := clWindowText;
      Exit;
    end;
  if roomkey = 7 then
    begin
      lblOR7.Font.Color := clWindowText;
      Exit;
    end;
  if roomkey = 8 then
    begin
      lblOR8.Font.Color := clWindowText;
      Exit;
    end;
  if roomkey = 9 then
    begin
      lblOR9.Font.Color := clWindowText;
      Exit;
    end;
  if roomkey = 10 then
    begin
      lblOR10.Font.Color := clWindowText;
      Exit;
    end;
  if roomkey = 11 then
    begin
      lblOR11.Font.Color := clWindowText;
      Exit;
    end;
  if roomkey = 12 then
    begin
      lblOR12.Font.Color := clWindowText;
      Exit;
    end;
  if roomkey = 13 then
    begin
      lblOR13.Font.Color := clWindowText;
      Exit;
    end;
  if roomkey = 14 then
    begin
      lblOR14.Font.Color := clWindowText;
      Exit;
    end;
  if roomkey = 15 then
    begin
      lblOR15.Font.Color := clWindowText;
      Exit;
    end;
end;

procedure TfrmSched.btnReschedClick(Sender: TObject);
var
  SchedCC: integer;
  Success, CCase: string;
begin
  SchedCC := 0;
  CCase := sCallV('APTWL CONCURRENT CASE', [SchedCase]);
  if piece(CCase, '^', 1) = '1' then
    begin
      if MessageDlg('There is a concurrent case associated with this operation:' + CRLF +
        '  ' + piece(CCase, '^' ,2) + CRLF + 'Do you want to schedule it for the same time?', mtConfirmation, [mbYes, mbNo], 0) = mrYes then SchedCC := 1;
    end;
  Success := sCallV('APTWL RESCHEDULE', [SchedCase, RoomIFN, SchedDate, SchedTim1, SchedTim2, memMove.Lines, SchedCC]);
  if piece(Success, '^', 1) = '1' then MessageDlg('Case #' + SchedCase + ' sucessfully moved to ' + lblNew.Caption, mtinformation, [mbOK], 0);
  if piece(Success, '^', 1) = '0' then MessageDlg('Case #' + SchedCase + ' could not be moved', mtinformation, [mbOK], 0);
  pnlMove.Visible := False;
  HideMove;
  Move := 0;
  RedrawSchedule;
end;

procedure TfrmSched.DisplayMove;
begin
  stMove3.Visible    := True;
  lblNew.Visible     := True;
  lblMove1.Visible   := True;
  memMove.Visible    := True;
  btnResched.Visible := True;
  btnAction.Visible  := True;
  bvlMove.Visible    := True;
  memMove.Clear;
end;

procedure TfrmSched.HideMove;
begin
  stMove3.Visible    := False;
  lblNew.Visible     := False;
  lblMove1.Visible   := False;
  memMove.Visible    := False;
  btnResched.Visible := False;
  btnAction.Visible  := False;
  bvlMove.Visible    := False;
end;

procedure TfrmSched.lblOR15Click(Sender: TObject);
begin
  ClearRoomLabels;
  lblOR15.Color := LoLite;
  lblOR15.Font.Color := clRed;
  pnlRoom.Top := lblOR15.Top + 25;
  RoomList(lbRoom.Items[15 + TopR]);
  roomkey := 15;
end;

procedure TfrmSched.lblOR15MouseLeave(Sender: TObject);
begin
  lblOR15.Color := LoLite;
end;

procedure TfrmSched.lblOR15MouseEnter(Sender: TObject);
begin
  lblOR15.Color := HiLite;
end;

procedure TfrmSched.btnReqClick(Sender: TObject);
begin
  if dbSurg.Text = '' then
    begin
      MessageDlg('Please enter an operation date', mtwarning, [mbOK],0);
      Exit;
    end;
  RefreshReq;
  lblReq.Caption := 'Surgery Requests for ' + dbSurg.Text;
  pnlReq.Visible := True;
  pnlReq.BringToFront;
end;

procedure TfrmSched.lbCReqClick(Sender: TObject);
var
  data: string;
begin
  data      := lbCReq.Items[lbCReq.ItemIndex];
  SpecIFN   := StrToInt(piece(data, '^', 1));
  if sCallV('APTWL IS SERVICE DEFINED', [SpecIFN]) = '0' then
    begin
      if MessageDlg('The ' + SpecName + ' specialty has no Service/Section definition.' + CRLF +
        'Please take care of that before using this specialty.', mtwarning, [mbOK, mbCancel], 0) = mrOK then
        begin
          GetService(frmSCMMain.cbSpec.Items);
          if frmService.btnExit.ModalResult = mrCancel then Exit;
        end
      else Exit;
    end;
  SpecName  := piece(data, '^', 2);
  SpecAbbr  := piece(data, '^', 8);
  SpecColor := StringToColor(piece(data, '^', 9));
  SchedCase := piece(data, '^', 3);
  SchedPt   := piece(data, '^', 4);
  SchedProc := piece(data, '^', 5);
  SchedSurg := piece(data, '^', 6);
  SchedAtt  := piece(data, '^', 7);
  DFN       := piece(data, '^', 12);
  SchedAnes := piece(data, '^', 13);
  Patient   := TPatient.Create;
  Patient.DFN := DFN;
  PtName    := SchedPt;
  Caption   := 'Schedule a ' + SpecName + ' case for ' + SchedPt;
  optkey    := 4;
  CaseDetail(SchedCase);
end;

procedure TfrmSched.btnQuitClick(Sender: TObject);
begin
  pnlReq.Visible := False;
  SpecIFN   := 0;
  SpecName  := '';
  SpecAbbr  := '';
  SpecColor := clWhite;
  SchedCase := '';
  Caption   := 'Surgery Schedule for ' + dbSurg.Text;
end;

procedure TfrmSched.cbAnesChange(Sender: TObject);
begin
  cbAnes.DroppedDown := True;
end;

procedure TfrmSched.cbSupvrChange(Sender: TObject);
begin
  cbSupvr.DroppedDown := True;
end;

procedure TfrmSched.RefreshReq;
begin
  lbCReq.Clear;
  CallV('APTWL GET REQ FOR DATE', [dbSurg.FMDateTime]);
  lbCReq.Items   := RPCBrokerV.Results;
end;

procedure TfrmSched.drgrSchedTopLeftChanged(Sender: TObject);
begin
  SetHeaders;
  SetRooms;
  ScrollTimer.Enabled := True;
end;

procedure TfrmSched.ScrollTimerTimer(Sender: TObject);
begin
  ScrollTimer.Enabled := False;
  RefreshSchedule;
end;

procedure TfrmSched.btnPrintClick(Sender: TObject);
var
  Title: string;
begin
  lbPTemp.Items.Clear;
  Title := 'Request List for ' + dbSurg.Text;
  GenPrint(lbCReq, Title, lbCReq.Pieces, lbCReq.TabPositions, lbPTemp);
end;

procedure TfrmSched.lbCReqMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  if Button = mbLeft then Exit;
  CaseDetail(SchedCase);
end;

procedure TfrmSched.btnDetClick(Sender: TObject);
begin
  pnlDetail.Visible := False;
  if optkey > 2 then pnlReq.Visible := True;
end;

procedure TfrmSched.CaseDetail(OpCase: string);
begin
  pnlDetail.Visible := True;
  pnlReq.Visible    := False;
  CallV('APTWL GET DAILY REQ DETAIL', [OpCase]);
  lbDetail.Items := RPCBrokerV.Results;
end;

procedure TfrmSched.lbDetailClick(Sender: TObject);
begin
  CallV('APTWL GET REQ DETAIL', [SchedCase, 'R']);
  ReportBox(RPCBrokerV.Results, 'Surgery Request Detail for ' + PtName, True);
  RefreshSchedule;
end;

procedure TfrmSched.cbCanChange(Sender: TObject);
begin
  if cbCan.Text = '' then Exit;
  CallV('APTWL GET CANCEL REASON', [cbCan.Text]);
  cbCan.Items := RPCBrokerV.Results;
  cbCan.DroppedDown := True;
end;

procedure TfrmSched.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  ResetTimeOut;
end;

procedure TfrmSched.btnEditClick(Sender: TObject);
begin
  EditRequest(SpecIFN);
  CaseDetail(SchedCase);
  RefreshSchedule;
end;

function TfrmSched.FindPM(X: integer): integer;
begin
  X := X +1;  // adjusted hour
  Result := X;
  if Result > 12 then Result := 1;
  First := First + 1;  // raw hour
  if First < 12 then
    begin
      AMPM := 'A';
      Exit;
    end;
  if (First > 11) and (First < 24) then
    begin
      AMPM := 'P';
      Exit;
    end;
  if (First + Result) > 23 then AMPM := 'A';
end;

procedure TfrmSched.cbCanClick(Sender: TObject);
begin
  CanIFN := cbCan.ItemIEN;
end;

procedure TfrmSched.lblEditClick(Sender: TObject);
begin
  ClearPopMenu;
  EditRequest(SpecIFN);
  RefreshSchedule;
end;

procedure TfrmSched.lblEditMouseEnter(Sender: TObject);
begin
  lblEdit.Color := clMoneyGreen;
end;

procedure TfrmSched.lblEditMouseLeave(Sender: TObject);
begin
  lblEdit.Color := clMedGray;
end;

procedure TfrmSched.btnPatInqClick(Sender: TObject);
begin
  PtInq;
end;

procedure TfrmSched.ScheduleSetUp;
var
  day: string;
begin
  if keyOK = 0 then
  begin
    day := sCallV('APTWL GET DAY', [surgDt]);
    lblDt1.Caption := day + ' ' + SurgDate;
    ClearCells;
    lbSpec.Clear;
    lbBlock.Clear;
    lbSched.Clear;
    ClearKey;
    pnlKey.Visible    := False;
    pnlReq.Visible    := False;
    pnlDetail.Visible := False;
    lbCReq.Items.Clear;
    lbDetail.Items.Clear;
    CallV('APTWL GET BLOCKOUT', [SurgDt, SiteIFN]);
    lbBlock.Items := RPCBrokerV.Results;
    CallV('APTWL GET SCHEDULE', [SurgDt, SiteIFN]);
    lbSched.Items := RPCBrokerV.Results;
  end;
  if (option = 0) or (option = 2) then DisplayColors(lbBlock, bsDiagCross);  // blockout schedule
  if (option = 1) or (option = 2) then DisplayColors(lbSched, bsSolid);  // case schedule
  if keyOK = 0 then KeyDisplay;
end;

end.
